/*	Code Table:
 *	1: Send Picture.
 *
 */

import java.io.*;
import java.net.*;
import java.awt.*;
import javax.media.*;
import javax.media.format.*;

class Server implements Runnable {
	private Thread video;
	private int fps;
	private int picSize;
	private DataOutputStream outToClient;
	private int portNum = 6789;
	private ImageProcessor imgp;
	private VideoFormat vFormat;
	private Player player;

  	public static void main(String args[])
  	{
  		Server driver = new Server();	
		driver.runServer();
 	}
 	
 	public void run() {
 		int frame = 0;
 		int delay = 1000 / fps;
 		long time = System.currentTimeMillis();
 		String name = "temp.jpg";
 		
 		while (Thread.currentThread() == video) {

 			try {
 				if (player == null) {
 					player = imgp.initPlayer(vFormat);
 				}
 				imgp.saveJPG(imgp.getFrame(player), name);
 				sendPic(outToClient, readPic(name)); 
 			}
 			catch (IOException e) {System.out.println("frame " + frame + " skipped");}
 		
 			try {
				time += delay;
				Thread.sleep(Math.max(0, time - System.currentTimeMillis()));
			}
			catch (Exception e) {
				break;
			}
			frame++;
		}
 	}
 	
 	public void runServer() {
 		InputStreamReader temp;
		int i = 0;

		// intialize the variables.
  		vFormat = new YUVFormat( new Dimension(176, 144), 38016, byte[].class,  (float)10.0, 2, 176, 88, 0, 25344, 31680) ;
  		imgp = new ImageProcessor();
		try {
			ServerSocket startSocket = new ServerSocket(portNum);
	
			while(true) {
				System.out.println("Waiting for clients on port: " + portNum);
				Socket connectionSocket = startSocket.accept();
	
				// create the inputstream and outputstream with the client.
				temp = new InputStreamReader(connectionSocket.getInputStream());
				BufferedReader inFromClient = new BufferedReader(temp);
				outToClient = new DataOutputStream(connectionSocket.getOutputStream());
			
				// reset player and image processor
				player = null;

				i = 0;
				while (!(connectionSocket.isClosed()) && (i != -1)) {		
					System.out.println("Waiting for client to send data");
				
					i = inFromClient.read();
					System.out.println("Byte from client: " + i);
				
					// 201 means request from client to initialize the camera
					if (i == 201) {
						player = imgp.initPlayer(vFormat);
						outToClient.writeInt(1);
						System.out.println("player initialized");
					}
					// 200 means request from client to send pic.
					else if (i == 200) {
						System.out.println("processing getFrame request");
						imgp.saveJPG(imgp.getFrame(player), "temp.jpg");
						sendPic(outToClient, readPic("temp.jpg"));
						System.out.println("picture sent");
					}
					else if (i == 202) {
						imgp.saveJPG(imgp.getFrame(player), "Frame.jpg");
					}
					// end video
					else if ( i == 255 ) {
						video = null;
					}
					// 0 to 30 are the only accepted fps.
					else if ( i > 0 && i < 30 ) {
						fps = i;
						video = new Thread (this);
						video.start();
					}
				}
			}
		}
		catch (Exception e) {
	  		e.printStackTrace();
		}
 	}
    
    public byte[] readPic(String name) throws IOException {
    	FileInputStream in = new FileInputStream(name);
		byte buffer[] = new byte[in.available()];
		picSize = buffer.length;
  		System.out.println("buffer length: " + buffer.length);
		in.read(buffer);
		return buffer;
    }
    
    public void sendPic(DataOutputStream ops, byte buf[]) throws IOException {
    	int length = buf.length;
   		
   		ops.flush();
    	ops.writeInt(length);
    	ops.write(buf, 0, length);
    }
}
